/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.api.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lambdaurora.lambdynlights.api.item.ItemLuminance;
import dev.lambdaurora.lambdynlights.api.predicate.ItemPredicate;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Range;

public class ItemLightSource {
    public static final Codec<ItemLightSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemPredicate.CODEC.fieldOf("match").forGetter(ItemLightSource::predicate), (App)ItemLuminance.CODEC.fieldOf("luminance").forGetter(ItemLightSource::luminance), (App)Codec.BOOL.optionalFieldOf("water_sensitive", (Object)false).forGetter(ItemLightSource::waterSensitive)).apply((Applicative)instance, ItemLightSource::new));
    private final ItemPredicate predicate;
    private final ItemLuminance luminance;
    private final boolean waterSensitive;

    public ItemLightSource(ItemPredicate predicate, ItemLuminance luminance, boolean waterSensitive) {
        this.predicate = predicate;
        this.luminance = luminance;
        this.waterSensitive = waterSensitive;
    }

    public ItemLightSource(ItemPredicate predicate, @Range(from=0L, to=15L) int luminance) {
        this(predicate, new ItemLuminance.Value(luminance));
    }

    public ItemLightSource(ItemPredicate predicate, ItemLuminance luminance) {
        this(predicate, luminance, false);
    }

    public ItemPredicate predicate() {
        return this.predicate;
    }

    public ItemLuminance luminance() {
        return this.luminance;
    }

    public boolean waterSensitive() {
        return this.waterSensitive;
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="3.0.0+1.21.1")
    public class_2960 id() {
        return null;
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="3.0.0+1.21.1")
    public class_1792 item() {
        return this.predicate.items().flatMap(items -> items.method_40239().findFirst()).map(class_6880::comp_349).orElse(null);
    }

    public @Range(from=0L, to=15L) int getLuminance(class_1799 stack) {
        if (this.predicate.test(stack)) {
            return this.luminance.getLuminance(stack);
        }
        return 0;
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="3.0.0+1.21.1")
    public int getLuminance(class_1799 stack, boolean submergedInWater) {
        return this.getLuminance(stack);
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="3.0.0+1.21.1")
    public static class BlockItemLightSource
    extends ItemLightSource {
        public BlockItemLightSource(class_2960 id, class_1792 item, class_2680 block, boolean waterSensitive) {
            super(ItemPredicate.Builder.item().of(new class_1935[]{item}).build(), new ItemLuminance.BlockReference(block.method_26204()), waterSensitive);
        }
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="3.0.0+1.21.1")
    public static class StaticItemLightSource
    extends ItemLightSource {
        public StaticItemLightSource(class_2960 id, class_1792 item, int luminance, boolean waterSensitive) {
            super(ItemPredicate.Builder.item().of(new class_1935[]{item}).build(), new ItemLuminance.Value(luminance), waterSensitive);
        }

        public StaticItemLightSource(class_2960 id, class_1792 item, int luminance) {
            this(id, item, luminance, false);
        }
    }
}

